<?php
/*
Simple:Press
Template Tag(s) - User Selection (theme/language)
$LastChangedDate: 2012-04-05 20:55:10 +0100 (Thu, 05 Apr 2012) $
$Rev: 8267 $
*/

if(preg_match('#' . basename(__FILE__) . '#', $_SERVER['PHP_SELF'])) {
	die('Access Denied');
}

function sp_UserSelectOptionsTag($args='', $labelTheme='', $labelLanguage='') {
	$defs = array('tagId' 			=> 'spUserSelectOptions',
				  'tagClass' 		=> 'spSelectOptions',
				  'themeClass'		=> 'spSelectTheme',
				  'languageClass'	=> 'spSelectLanguage',
				  'labelClass'		=> 'spLabel',
				  'selectClass'		=> 'spSelect',
				  'theme'			=> 1,
				  'language'		=> 1,
				  'spacer'			=> '&nbsp;&nbsp;&nbsp;&nbsp;',
				  'stacked'			=> 0
				  );
	$a = wp_parse_args($args, $defs);
	$a = apply_filters('sph_UserSelectOptions_args', $a);
	extract($a, EXTR_SKIP);

	# sanitize before use
	$tagId			= esc_attr($tagId);
	$tagClass		= esc_attr($tagClass);
	$themeClass		= esc_attr($themeClass);
	$languageClass	= esc_attr($languageClass);
	$labelClass	    = esc_attr($labelClass);
	$selectClass	= esc_attr($selectClass);
	$theme			= (int) $theme;
	$language		= (int) $language;
	$spacer			= esc_attr($spacer);
	$stacked		= (int) $stacked;

	if (!empty($labelTheme)) $labelTheme = sp_filter_title_display($labelTheme);
	if (!empty($labelLanguage)) $labelLanguage = sp_filter_title_display($labelLanguage);

	$sfstorage = array();
	$sfstorage = sp_get_option('sfconfig');
	$overlays = '';

	if ($theme) {
		$currentTheme = sp_get_current_sp_theme();
		if ($currentTheme['color'] ? $overlays = sp_get_overlays(SPTHEMEBASEDIR.$currentTheme['theme'].'/styles/overlays') : $overlays = '');
	}
	if ($language ? $langs = get_available_languages(WP_CONTENT_DIR.'/'.$sfstorage['language-sp']) : $langs='');

    $out = '';

	if (($theme && $overlays) || ($language && $langs)) {
		$out.= "<div id='$tagId' class='$tagClass'>";

		if ($theme && $overlays) {
			if (isset($_COOKIE['overlay'])) $currentTheme['color'] = $_COOKIE['overlay'];
            $out.= "<span class='$themeClass'>";
            if (!empty($labelTheme)) $out.= "<label class='$labelClass'>$labelTheme</label>";
    		$out.= "<select name='overlay' class='$selectClass' onchange='spjSetUserOption(this);' >";
			$out.= '<optgroup label="'.__('Select Theme', 'sp-usel').':">';
			$out.= '<option'.$selected.' value="ovdefault">'.esc_html(__('Site Default', 'sp-usel')).'</option>';
			foreach ($overlays as $overlay) {
				$overlay = trim($overlay);
				$selected = ($overlay == $currentTheme['color']) ? ' selected="selected" ' : '';
				$out.= '<option'.$selected.' value="'.esc_attr($overlay).'">'.esc_html($overlay).'</option>';
			}
			$out.= '</optgroup></select>';
            $out.= '</span>';
			if ($language && $langs) {
				if ($stacked ? $out.= sp_InsertBreak('echo=0') : $out.= $spacer);
			}
		}

		if ($language && $langs) {
			$out.= "<span class='$languageClass'>";
			if (!empty($labelLanguage)) $out.= "<label class='$labelClass'>$labelLanguage</label>";
			$out.= "<select name='language' class='$selectClass' onchange='spjSetUserOption(this);' >";
			$out.= '<optgroup label="'.__('Select Language', 'sp-usel').':">';
			$selected = (!isset($_COOKIE['language']) || $_COOKIE['language'] == 'default') ? ' selected="selected" ' : '';
			$out.= '<option'.$selected.' value="default">'.esc_html(__('Site Default', 'sp-usel')).'</option>';
			$langs[] = 'en';
			sort($langs);
			foreach ($langs as $lang) {
				$lang = str_replace('sp-', '', trim($lang));
				$selected = ($lang == $_COOKIE['language']) ? ' selected="selected" ' : '';
				$out.= '<option'.$selected.' value="'.esc_attr($lang).'">'.esc_html($lang).'</option>';
			}
			$out.= '</optgroup></select>';
			$out.= '</span>';
		}

		$out.= "</div>";
	}

	$out = apply_filters('sph_UserSelectOptions', $out, $a);
    echo $out;
}

?>