<?php
/*
Simple:Press Plugin Title: Language and Theme Selection
Version: 1.0.2
Plugin URI: http://simple-press.com
Description: Adds front end selection boxes that allows a user to select their own overlay/color and/or language preferences
Author: Andy Staines & Steve Klasen
Author URI: http://simple-press.com
Simple:Press Versions: 5.1.2 and above
NOTE: This plugin will show any languages that you have installed in the Simple Press Languages folder.
To get a site fully translated you will want to download the core, theme and plugin translations as all are used on the front end.
You can get available translations from our Simple Press translation site at http://glotpress.simple-press.com/
More information can be found at: http://codex.simple-press.com/codex/installation/installation-information/localization/
Do not change the WPLANG constant for this plugin unless you want your whole site in that language.
Selecting the Site Default will give users the language set by WPLANG.
*/

if (preg_match('#'.basename(__FILE__).'#', $_SERVER['PHP_SELF'])) die('Access denied - you cannot directly call this file');

# IMPORTANT DB VERSION
define('SPUSELDBVERSION', 0);

# ======================================
# CONSTANTS USED BY THIS PLUGIN
# ======================================
define('SPUSELDIR',   SFPLUGINDIR.'user-selection/');
define('SPUSELJS',	SFPLUGINURL.'user-selection/resources/jscript/');

# ======================================
# ACTIONS/FILTERS USED BY THUS PLUGIN
# ======================================
# Plugin and admin
add_action('init', 				                                              'sp_user_selection_localisation');
add_action('sph_scripts_end', 	                                              'sp_user_selection_load_js');
add_filter('sph_theme',			                                              'sp_user_selection_set_overlay');
add_filter('sph_localization_mo', 				                              'sp_user_selection_set_lang');
add_filter('sph_localization_plugin_mo', 				                      'sp_user_selection_set_plugin_lang', 10, 2);
add_filter('sph_localization_theme_mo', 				                      'sp_user_selection_set_theme_lang', 10, 2);
add_action('sph_activate_user-selection/sp-user-selection-plugin.php',        'sp_user_selection_install');
add_action('sph_uninstall_user-selection/sp-user-selection-plugin.php',	      'sp_user_selection_uninstall');
add_action('admin_footer',                                                    'sp_user_selection_upgrade_check');
add_action('sph_plugin_update_user-selection/sp-user-selection-plugin.php',   'sp_user_selection_upgrade_check');
add_filter('sph_plugins_active_buttons',						              'sp_user_selection_uninstall_option', 10, 2);

# ======================================
# PLUGIN AND ADMIN
# ======================================

# ------------------------------------------------------
# Set up language file
# ------------------------------------------------------
function sp_user_selection_localisation() {
	sp_plugin_localisation('sp-usel');
}

function sp_user_selection_install() {
    include_once(SPUSELDIR.'sp-user-selection-install.php');
    sp_user_selection_do_install();
}

function sp_user_selection_uninstall() {
    include_once(SPUSELDIR.'sp-user-selection-uninstall.php');
    sp_user_selection_do_uninstall();
}

function sp_user_selection_uninstall_option($actionlink, $plugin) {
    include_once(SPUSELDIR.'sp-user-selection-uninstall.php');
    $actionlink = sp_user_selection_do_uninstall_option($actionlink, $plugin);
	return $actionlink;
}

function sp_user_selection_upgrade_check() {
    include_once(SPUSELDIR.'sp-user-selection-upgrade.php');
    sp_user_selection_do_upgrade_check();
}

# ------------------------------------------------------
# Load the preview script
# ------------------------------------------------------
function sp_user_selection_load_js($footer) {
	global $sfvars;
	wp_enqueue_script('spoverlay', SPUSELJS.'sp-user-selection.js', array('jquery'), false, $footer);
}

# ------------------------------------------------------
# Reset language from cookie for page load
# ------------------------------------------------------
function sp_user_selection_set_lang($mofile) {
	global $SPPATHS;
	if (isset($_COOKIE['language']) && $_COOKIE['language'] != 'default') $mofile = WP_CONTENT_DIR.'/'.$SPPATHS['language-sp'].'/sp-'.$_COOKIE['language'].'.mo';
    return $mofile;
}

function sp_user_selection_set_plugin_lang($mofile, $domain) {
	global $SPPATHS;
	if (isset($_COOKIE['language']) && $_COOKIE['language'] != 'default') $mofile = WP_CONTENT_DIR.'/'.$SPPATHS['language-sp-plugins'].'/'.$domain.'-'.$_COOKIE['language'].'.mo';
    return $mofile;
}

function sp_user_selection_set_theme_lang($mofile, $domain) {
	global $SPPATHS;
	if (isset($_COOKIE['language']) && $_COOKIE['language'] != 'default') $mofile = WP_CONTENT_DIR.'/'.$SPPATHS['language-sp-themes'].'/'.$domain.'-'.$_COOKIE['language'].'.mo';
    return $mofile;
}

# ------------------------------------------------------
# Reset theme color from cookie for page load
# ------------------------------------------------------
function sp_user_selection_set_overlay($theme) {
	if (isset($_COOKIE['overlay']) && isset($theme['color'])) {
		if ($_COOKIE['overlay'] != 'ovdefault') {
			$theme['color'] = $_COOKIE['overlay'];
		}
	}
	return $theme;
}

# ------------------------------------------------------
# TEMPLATE TAG
# ------------------------------------------------------
function sp_UserSelectOptions($args='', $labelTheme='', $labelLanguage='') {
	include_once(SPUSELDIR.'template-tags/sp-user-selection-tags.php');
	sp_UserSelectOptionsTag($args, $labelTheme, $labelLanguage);
}

?>